
**************************************************
***   (Violation) Parallel Trends Assumption
***        Volker Ludwig, Josef Brüderl
***              October 2016
**************************************************

clear 
set more off

* Data Path
cd  "C:\Users\bruederl\LRZ Sync+Share\Vorlesung PDA\Stata Beispiele\Artificial Data\"
* cd "D:\Projekte\FEIS\"

*************************************************************
*****      Parallel Trends Assumption valid             *****
*************************************************************
use "FEIS Parallel Trends.dta", clear
drop if id==3
xtset id t

// Graph of the data (the treatment effect (TE) is +1000)
bys id (t) : egen treat=max(x) 
scatter y t if treat==0 , msymbol(Oh) mcolor(black) msize(large) ///
	|| lfit y t if treat==0 , lcolor(black) ///
	|| scatter y t if treat==1 & inlist(t,1,2,3,4), msymbol(x) mcolor(gs7) msize(huge)  ///
	|| lfit y t if treat==1 & x==0, lcolor(gs7) ///
	|| lfit y t if treat==1 & x==1, lcolor(gs7) ///
	|| , ylabel(1000(500)5000, grid angle(0)) xlabel(1(1)4) xline(2.5, lpattern(dash)) ///
		 ytitle("Einkommen (y)") xtitle("Zeit (t)") ///
		 legend(order(1 "Person 1" 3 "Person 2") ring(0) pos(1))


// Transformed Data
list id t y x D.(t y x) D2.(t y x), sepby(id)


* Models without modelling the trend
xtreg y x, fe         // FE does not work (TE 2000)
reg D.(y x), nocons   // FD does not work (TE 1500)
reg D2.(y x), nocons  // SD works
xtfeis y x, slope(t)  // FEIS works

* Models with modelling the trend
xtreg y x t, fe         // FE works
reg D.(y x t), nocons   // FD works
reg D2.(y x t), nocons  // SD works
xtfeis y x, slope(t)    // FEIS works


*************************************************************
*****      Parallel Trends Assumption not valid         *****
*************************************************************
use "FEIS Parallel Trends.dta", clear
drop if id==1
xtset id t

// Graph of the data (the treatment effect (TE) is +1000)
bys id (t) : egen treat=max(x) 
scatter y t if treat==0 , msymbol(Oh) mcolor(black) msize(large) ///
	|| lfit y t if treat==0 , lcolor(black) ///
	|| scatter y t if treat==1 & inlist(t,1,2,3,4), msymbol(x) mcolor(gs7) msize(huge)  ///
	|| lfit y t if treat==1 & x==0, lcolor(gs7) ///
	|| lfit y t if treat==1 & x==1, lcolor(gs7) ///
	|| , ylabel(1000(500)6000, grid angle(0)) xlabel(1(1)4) xline(2.5, lpattern(dash)) ///
		 ytitle("Einkommen (y)") xtitle("Zeit (t)") ///
		 legend(order(1 "Person 3" 3 "Person 2") ring(0) pos(11))


// Transformed Data
list id t y x D.(t y x) D2.(t y x), sepby(id)


* Models with modelling the trend
xtreg y x t, fe         // FE does not work (TE 167)
reg D.(y x t), nocons   // FD does not work work (TE 700)
reg D2.(y x t), nocons  // SD works
xtfeis y x, slope(t)    // FEIS works


// Why does FD not work?		 
scatter        D.y D.x if treat==0 , jitter(5) msymbol(Oh) mcolor(black) ///
	|| scatter D.y D.x if treat==1 , jitter(5) msymbol(Dh) mcolor(gs7) ///
	|| lfit    D.y D.x ///
	|| , ylabel(0(500)2000, grid angle(0)) legend(order(1 "not treated" 2 "treated") ring(0) pos(11))
* FD estimates a common trend that is biased upwards


* Why does SD work?
scatter        D2.y D2.x if treat==0 , jitter(5) msymbol(Oh) mcolor(black) msize(large) ///
	|| scatter D2.y D2.x if treat==1 , msymbol(x) mcolor(gs7) msize(huge) ///
	|| lfit    D2.y D2.x ///
	|| , ylabel(-1000(500)1000, grid angle(0)) ///
		 ytitle("Einkommen (SD y)") xtitle("Umschulung (SD x)") ///
		 legend(label(1 "Person 1") label(2 "Person 2") label(3 "Reg.gerade") ring(0) pos(11))


* Why does FEIS work?
xtfeis y x, slope(t) transformed(DT)  //Detrend data  

// Transformed Data
list id t y x DTy DTx, sepby(id)

scatter        DTy DTx if treat==0 , jitter(5) msymbol(Oh) mcolor(black) ///
	|| scatter DTy DTx if treat==1 , msymbol(Dh) mcolor(gs7) ///
	|| lfit    DTy DTx ///
	|| , ylabel(-500(500)500, grid angle(0)) legend(order(1 "not treated" 2 "treated") ring(0) pos(11))




		 

**************************************************
// A nicer graph of the data
count
set obs 10
sort id
replace id=2 if _n>8
replace t=2.49 if _n==9
replace t=2.51 if _n==10
replace x=0 if _n==9
replace x=1 if _n==10
replace y=1000+500*(t-1)+1000*x if y==.

drop treat
bys id (t) : egen treat=max(x) 
sort id t
list id t y x treat

scatter        y t if treat==0 , msymbol(Oh) mcolor(black) msize(large) ///
	|| lfit    y t if treat==0 , lcolor(black) ///
	|| scatter y t if treat==1 & inlist(t,1,2,3,4), msymbol(x) mcolor(gs7) msize(huge)  ///
	|| lfit    y t if treat==1 & x==0, lcolor(gs7) ///
	|| lfit    y t if treat==1 & x==1, lcolor(gs7) ///
	|| , ylabel(1000(500)6000, grid angle(0)) xlabel(1(1)4) xline(2.5, lpattern(dash)) ///
		 ytitle("Einkommen (y)") xtitle("Zeit (t)") ///
		 legend(order(1 "Person 3" 3 "Person 2") ring(0) pos(11))


